/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import sedona.Bool;
import sedona.Buf;
import sedona.Byte;
import sedona.Component;
import sedona.Double;
import sedona.Env;
import sedona.Float;
import sedona.Int;
import sedona.Long;
import sedona.Schema;
import sedona.Short;
import sedona.Slot;
import sedona.Str;
import sedona.Value;
import sedona.dasp.DaspSocket;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.sox.SoxClient;
import sedona.util.FileUtil;
import sedona.util.UserUtil;
import sedona.xml.XWriter;
import sedonac.Compiler;
import sedonac.test.Test;
import sedonac.test.TestException;

public abstract class AbstractSoxTest
extends Test {
    static final int TREE = 1;
    static final int CONFIG = 2;
    static final int RUNTIME = 4;
    static final int LINKS = 8;
    Process proc;
    DaspSocket sock;
    Schema schema;
    SoxClient client;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test() throws Exception {
        try {
            this.startServer();
            this.doTest();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Component.testMode = false;
            this.stopClient();
            this.stopServer();
            throw throwable;
        }
        {
            Object var2_3 = null;
            Component.testMode = false;
        }
        this.stopClient();
        this.stopServer();
    }

    public abstract void doTest() throws Exception;

    private final void stopClient() throws Exception {
        try {
            this.client.close();
        }
        catch (Exception exception) {}
    }

    private final void startServer() throws Exception {
        this.sock = DaspSocket.open((int)-1, null, (int)14);
        OfflineApp offlineApp = this.buildApp();
        File file = this.writeAppFile(offlineApp);
        File file2 = this.writeScodeFile(offlineApp.schema);
        this.spawnApp(file2, file);
    }

    public abstract OfflineApp buildApp() throws Exception;

    private final File writeAppFile(OfflineApp offlineApp) throws Exception {
        File file = new File(this.testDir(), "app.sab");
        Buf buf = offlineApp.encodeAppBinary();
        buf.flip();
        buf.writeTo(file);
        return file;
    }

    private final File writeScodeFile(Schema schema) throws Exception {
        File file = new File(this.testDir(), "kits.xml");
        XWriter xWriter = new XWriter(file);
        xWriter.write("<sedonaCode endian='little' blockSize='4'\n");
        xWriter.write("   refSize='4' main='sys::Sys.main' debug='true' test='true'>\n");
        int n = 0;
        while (n < schema.kits.length) {
            xWriter.write("<depend on='" + schema.kits[n].name + " 0+'/>\n");
            ++n;
        }
        xWriter.write("</sedonaCode>\n");
        xWriter.close();
        System.out.print("-- Compile " + file);
        Compiler compiler = new Compiler();
        compiler.compile(file);
        return new File(this.testDir(), "kits.scode");
    }

    private final void spawnApp(File file, File file2) throws Exception {
        String string;
        Process process = Runtime.getRuntime().exec("tasklist");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf(this.getSvmName()) < 0) continue;
            throw new TestException("Cannot continue; " + this.getSvmName() + " already running!");
        }
        File file3 = new File(Env.home, "bin" + File.separator + this.getSvmName());
        FileUtil.copyFile((File)file3, (File)new File(this.testDir(), file3.getName()));
        String string2 = file3.getName() + " kits.scode app.sab";
        System.out.println("###### " + string2 + " ######");
        this.proc = Runtime.getRuntime().exec(string2, null, this.testDir());
        new Thread("ProcOut"){

            public final void run() {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(AbstractSoxTest.this.proc.getInputStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        System.out.println("[s] " + string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }.start();
    }

    private final void stopServer() throws Exception {
        this.sock.close();
        if (this.proc != null) {
            this.proc.destroy();
            this.proc.waitFor();
        }
    }

    public Value read(OfflineComponent offlineComponent, String string) throws Exception {
        return this.client.readProp(offlineComponent.id(), offlineComponent.type.slot(string, true));
    }

    public boolean readBool(OfflineComponent offlineComponent, String string) throws Exception {
        return ((Bool)this.client.readProp((int)offlineComponent.id(), (Slot)offlineComponent.type.slot((String)string, (boolean)true))).val;
    }

    public int readByte(OfflineComponent offlineComponent, String string) throws Exception {
        return ((Byte)this.client.readProp((int)offlineComponent.id(), (Slot)offlineComponent.type.slot((String)string, (boolean)true))).val;
    }

    public int readShort(OfflineComponent offlineComponent, String string) throws Exception {
        return ((Short)this.client.readProp((int)offlineComponent.id(), (Slot)offlineComponent.type.slot((String)string, (boolean)true))).val;
    }

    public int readInt(OfflineComponent offlineComponent, String string) throws Exception {
        return ((Int)this.client.readProp((int)offlineComponent.id(), (Slot)offlineComponent.type.slot((String)string, (boolean)true))).val;
    }

    public long readLong(OfflineComponent offlineComponent, String string) throws Exception {
        return ((Long)this.client.readProp((int)offlineComponent.id(), (Slot)offlineComponent.type.slot((String)string, (boolean)true))).val;
    }

    public float readFloat(OfflineComponent offlineComponent, String string) throws Exception {
        return ((Float)this.client.readProp((int)offlineComponent.id(), (Slot)offlineComponent.type.slot((String)string, (boolean)true))).val;
    }

    public double readDouble(OfflineComponent offlineComponent, String string) throws Exception {
        return ((Double)this.client.readProp((int)offlineComponent.id(), (Slot)offlineComponent.type.slot((String)string, (boolean)true))).val;
    }

    public Buf readBuf(OfflineComponent offlineComponent, String string) throws Exception {
        return (Buf)this.client.readProp(offlineComponent.id(), offlineComponent.type.slot(string, true));
    }

    public String readStr(OfflineComponent offlineComponent, String string) throws Exception {
        return ((Str)this.client.readProp((int)offlineComponent.id(), (Slot)offlineComponent.type.slot((String)string, (boolean)true))).val;
    }

    public void write(OfflineComponent offlineComponent, String string, int n) throws Exception {
        this.client.write(offlineComponent.id(), offlineComponent.type.slot(string, true), (Value)Int.make((int)n));
    }

    public void invoke(OfflineComponent offlineComponent, String string, Value value) throws Exception {
        this.client.invoke(offlineComponent.id(), offlineComponent.type.slot(string, true), value);
    }

    public void invoke(OfflineComponent offlineComponent, String string, int n) throws Exception {
        this.invoke(offlineComponent, string, (Value)Int.make((int)n));
    }

    public void trace(String string) {
        System.out.println("[>] " + string);
    }

    public void pause() throws Exception {
        Thread.sleep(100L);
    }

    OfflineComponent addAdmin(OfflineComponent offlineComponent, String string, String string2) {
        Schema schema = offlineComponent.type.schema;
        OfflineComponent offlineComponent2 = offlineComponent.app().add(offlineComponent, new OfflineComponent(schema.type("sys::User"), string));
        offlineComponent2.setBuf("cred", new Buf(UserUtil.credentials((String)string, (String)string2)));
        offlineComponent2.setInt("perm", -1);
        offlineComponent2.setInt("prov", 255);
        return offlineComponent2;
    }
}

